#!/bin/sh
PATH=/bin:/usr/bin:/sbin:/usr/sbin:/root/bin:/mnt/card:/mnt/card/root/bin
CUT=/mnt/card/cut
emptyFPGA=no
updatedKernel=no

##########################################################
# < ̾ : vgno >
# ) Update뵡ˤ碌ѹ!!
##########################################################
vgno="859"
vgtype="VG"$vgno
vgfname="vg"$vgno".o"

##########################################################
# < VGС : version >
# ) ΤΥСɬ碌뤳!!
##########################################################
version="6.20"
versionUpMsg="Versionup "$vgtype" v"$version

##########################################################
# < ͥС > : kernelVer
# ) zImageΥСɬ碌뤳ȡ!
#       ɤ˿zImageƤ⤳åץǡΥСƱ硢
#       åץǡȤʤΤ!!
##########################################################
kernelVer="0.71"

##########################################################
# < FPGAС > : fpgaVer
# ) FPGAΥСɬ碌뤳ȡ!
#       ɤ˿FPGAƤ⤳åץǡΥСƱ硢
#       åץǡȤʤΤ!!
##########################################################
# FPGAСβ
fpgaVer="B361D"

#-----------------------------------#
#              functions
#-----------------------------------#

#---=== Video board H8 version check ===---
chkprg=/mnt/card/h8version
function chkver()
{
    if [ -x $chkprg ]
    then
        $chkprg
        return $?
    fi
    echo " Not found $chkprg."
    return -1
}

function errorbuzzer()
{
    testvram buzzer 4
}

function endingbuzzer()
{
    testvram buzzer 16
}

#--- ưƤץλ ---
function killvg()
{
    if [ -s /var/run/vg.pid ]
    then
        echo " Stoping vg.o ....."
        dispout 1 " Stoping "$vgtype" .....   "
        kill `cat /var/run/vg.pid`
    fi
    if [ -s /var/run/vg848.pid ]
    then
        echo " Stoping VG-848 ....."
        dispout 1 " Stoping VG-848 .....   "
        kill `cat /var/run/vg848.pid`
    fi
}

#--- ץνλԤ ---
function waitKillVg()
{
    PID=`ps ax | grep vg.o | grep -v grep | ${CUT} -f 4 -d " "`
    echo "pid :"$PID
    while [ "$PID" != "" ]
    do
        echo " Wait for vg.o.(1 seconds) ....."
        kill -9 $PID
        sleep 1
        PID=`ps ax | grep vg.o | grep -v grep | ${CUT} -f 4 -d " "`
        echo "pid :"$PID
    done
}

function writeFPGA()
{
    #--- ɹѤˤ ---
    mount -o remount,ro /mnt/flash3

    #--- FPGA򹹿 ---
    if [ -s /mnt/card/fpgawriter.o ]
    then
        echo " Update FPGA"
        dispout 1 " FPGA WRITING .....     "
        /mnt/card/fpgawriter.o
    #   echo "Return Code : " $?
        case $? in
            255)dispout 1 "Warning FPGA WRITE ERR!!"
                errorbuzzer
                exit
                ;;
            254)dispout 1 "Warning FPGA NMAP ERR!!"
                errorbuzzer
                exit
                ;;
            253)dispout 1 " Missing Device file !!"
                errorbuzzer
                exit
                ;;
            252)dispout 1 " Missing h8main.mot !!"
                errorbuzzer
                exit
                ;;
            251)dispout 1 " Missing fpgawriter.o !!"
                errorbuzzer
                exit
                ;;
        esac
    fi
}


#-----------------------------------#
#              main
#-----------------------------------#

# LCDν
dispout

#
#--- ӥǥܡɤΣȣեåŤߤ ---
#
chkver
case $? in
  0)  echo "=== Versionup "$vgtype" v"$version "==="
      dispout
      dispout 0 "Versionup "$vgtype" v"$version
    ;;
 255) dispout 0 " Warning: FPGA is empty."
      dispout 1 "                        "
      errorbuzzer
      killvg
      waitKillVg
      sleep 3
      dispout 0 "Versionup "$vgtype" v"$version"   "
      dispout 1 "                        "
      emptyFPGA=yes
    ;;
  *)  dispout 0 " Warning: FPGA is old.  "
      dispout 1 "     Abort update.      "
      errorbuzzer
      sleep 5
      killvg
      waitKillVg
      exit 2
esac


#
#--- Ʊ쵡狼Ĵ١äƤ齪λ ---
#
if [ -s /astro/$vgfname ]
then
    sleep 2
else
    echo " Different VG type ..."
    dispout 0 "This upgrade firmware is"
    dispout 1 "    not for VG-"$vgno" !!!  "
    errorbuzzer
    exit
fi

#
#--- ¹ԥեĴ١Ʊä齪λ ---
#
diff /mnt/card/$vgfname /astro/$vgfname
if [ $? = 0 ]
then
    echo $vgfname" is same!! Don't update."
    dispout
    dispout 0 "Firmware is same version"
    dispout 1 " An update was stopped. "
    errorbuzzer
    exit
fi

#
#--- ͥ򹹿(loop ǥХʤΤ) ---
#
grep loop /proc/devices > /dev/null
if [ $? != 0 ]
then
    if [ -s /mnt/card/zImage ]
    then
        if [ "$updatedKernel" != yes ]
        then
            echo " Update zImage"
            dispout 1 " Update zImage .....    "
            eraseall /dev/mtd2
            cp -f /mnt/card/zImage /dev/mtd2
            sync
            sync
            sync
            dispout 1 "    Updated zImage.     "
            sleep 2
        fi
        dispout 0 "Turn on the power again,"
        dispout 1 "  and do renewal work.  "
        endingbuzzer
    else
        dispout 1 "    Not found zImage.   "
        errorbuzzer
    fi
    exit
fi

#
#--- ưƤץλ ---
#
killvg

#
#--- ץνλԤ ---
#
waitKillVg

#
#--- PID Fileκ ---
#
if [ -s /var/run/vg.pid ]
then
    rm /var/run/vg.pid
fi
if [ -s /var/run/vg848.pid ]
then
    rm /var/run/vg848.pid
fi
if [ -s /var/run/udpproc.pid ]
then
    rm /var/run/udpproc.pid
fi

#
#--- ɽ ---
#
dispout
dispout 0 "$versionUpMsg"
dispout 1 " Update "$vgfname

#
#--- ߲ǽˤ ---
#
echo " Remount r/w mode ....."
dispout 1 " Remount r/w mode ..... "
mount -o remount,rw /mnt/flash3

#
#--- 롼ȥե륷ƥ๹ν ---
#
#    /root/config.conf/mnt/card/rootfs-setup.imgå
#    ¸ߤ /etcmotdnetwork/interfacesʳΥե
#
if [ -s /root/config.conf -a -s /mnt/card/rootfs-setup.img ]
then
    echo " Remove /etc ....."
    mv /etc/network/interfaces /home/tftp
    mv /etc/motd /home/tftp
    rm -rf /etc/*
#    ln -s /proc/mounts /etc/mtab
    mkdir /etc/network
    mv /home/tftp/interfaces /etc/network
    mv /home/tftp/motd /etc
else
    echo " Not found /root/config.conf & /mnt/card/rootfs-setup.img"
fi

#
#--- ǽ˥ե ---
#
cd /astro
if [ -s testvram ]
then
    rm testvram
fi
for fname in vg*.o
do
    rm $fname
    echo " remove "$fname
    dispout 1 "                        "
    dispout 1 " Remove "$fname
done
cd

#
#--- μ¤˥ե ---
#
sync
mount -n -o remount,ro /mnt/flash3
sync
mount -n -o remount,rw /mnt/flash3

#
#--- vg8xx.o򹹿 ---
#
if [ -s /mnt/card/$vgfname ]
then
    dispout
    dispout 0 "$versionUpMsg"
    dispout 1 " Update "$vgfname
    cp -af /mnt/card/$vgfname /astro
    echo " Update "$vgfname" ....."
    echo " Update Ver."$version
fi

#
#--- udpproc򹹿(VersionۤʤΤ) ---
#
diff /mnt/card/udpproc /astro/udpproc
if [ $? != 0 ]
then
    echo " /astro/udpproc"
    dispout 1 " Update udpproc .....   "
    cp -af /mnt/card/udpproc /astro
fi

#
#--- ͥ򹹿(VersionۤʤΤ) ---
#
VER=`grep version /proc/vram | ${CUT} -f 3 -d " "`
if [ $kernelVer != $VER ]
then
    if [ -s /mnt/card/zImage ]
    then
        echo " Update zImage"
        dispout 1 " Update zImage .....    "
        eraseall /dev/mtd2
        cp -f /mnt/card/zImage /dev/mtd2
        updatedKernel=yes
    fi
else
    echo "Kernel is same!! Don't update zImage."
fi
echo "OLD kernel ver:"$VER
echo "NEW kernel ver:"$kernelVer

if [ -e /mnt/card/motd.$vgno ]
then
    cp -af /mnt/card/motd.$vgno /etc/motd
fi


#
#--- 󥯤 ---
#
ln -s /astro/$vgfname /astro/vg.o

#
#--- FPGA򹹿 ---
#
VER=`/mnt/card/h8version | grep Revison | ${CUT} -f 5 -d " " | ${CUT} -c 4-`
if [ "$emptyFPGA" = yes ] || [ $fpgaVer != $VER ]
then
    writeFPGA
else
    echo "FPGA is same!! Don't update FPGA."
fi

sync
sync
sync



#---------------------------------------------------------------------------------------------#
# /root/config.conf/mnt/card/rootfs-setup.img硢롼ȥե륷ƥؤ #
#---------------------------------------------------------------------------------------------#


#
#--- /root/config.conf/mnt/card/rootfs-setup.imgå¸ߤƤʤʤ鲿⤻λ ---
#
if !([ -s /root/config.conf -a -s /mnt/card/rootfs-setup.img ])
then
    dispout 1 "  Versionup complete.   "
    sleep 2
    dispout 1 "   Please power off.    "
    endingbuzzer
    exit
fi

updateMsg="=== Update: FLASH #5 ==="
#
#--- åȥåѤΥ롼ȥե륷ƥޥȤ  ---
#
if [ -s /mnt/card/rootfs-setup.img ]
then
    dispout 0 "$updateMsg"
    dispout 1 "                        "
    mount -n -t cramfs -o loop /mnt/card/rootfs-setup.img /mnt/card
else
    dispout 0 "Not found rootfs-setup. "
    dispout 1 "     Abort update.      "
    errorbuzzer
    exit
fi

#
#--- 롼ȥե륷ƥ򹹿  ---
#
if [ -s /mnt/card/rootfs.img ]
then
    dispout 0 "$updateMsg"
    dispout 1 "                        "
    chroot /mnt/card updateFlash5.sh
else
    dispout 0 "Not found FLASH #5 data."
    dispout 1 "     Abort update.      "
    errorbuzzer
    exit
fi

dispout 0 "  Versionup complete.   "
dispout 1 "   Please power off.    "

endingbuzzer
exit 0
